/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 13:00:57 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "signal_private_gencoswin.h"
#include "libmatlbm.h"
#include "libmmfile.h"
#include "signal_private_check_order.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;
static mxArray * _mxarray2_;

static mxChar _array4_[9] = { 's', 'y', 'm', 'm', 'e', 't', 'r', 'i', 'c' };
static mxArray * _mxarray3_;
static mxArray * _mxarray5_;

static mxChar _array9_[8] = { 'p', 'e', 'r', 'i', 'o', 'd', 'i', 'c' };
static mxArray * _mxarray8_;

static mxArray * _array7_[2] = { NULL /*_mxarray3_*/, NULL /*_mxarray8_*/ };
static mxArray * _mxarray6_;

static mxChar _array11_[55] = { 'S', 'a', 'm', 'p', 'l', 'i', 'n', 'g',
                                ' ', 'f', 'l', 'a', 'g', ' ', 'm', 'u',
                                's', 't', ' ', 'b', 'e', ' ', 'e', 'i',
                                't', 'h', 'e', 'r', ' ', 0x0027, 's', 'y',
                                'm', 'm', 'e', 't', 'r', 'i', 'c', 0x0027,
                                ' ', 'o', 'r', ' ', 0x0027, 'p', 'e', 'r',
                                'i', 'o', 'd', 'i', 'c', 0x0027, '.' };
static mxArray * _mxarray10_;
static mxArray * _mxarray12_;

static mxChar _array14_[4] = { 'h', 'a', 'n', 'n' };
static mxArray * _mxarray13_;
static mxArray * _mxarray15_;
static mxArray * _mxarray16_;

static mxChar _array18_[7] = { 'h', 'a', 'm', 'm', 'i', 'n', 'g' };
static mxArray * _mxarray17_;
static mxArray * _mxarray19_;
static mxArray * _mxarray20_;

static mxChar _array22_[8] = { 'b', 'l', 'a', 'c', 'k', 'm', 'a', 'n' };
static mxArray * _mxarray21_;
static mxArray * _mxarray23_;
static mxArray * _mxarray24_;

static mxChar _array26_[10] = { 'f', 'l', 'a', 't', 't',
                                'o', 'p', 'w', 'i', 'n' };
static mxArray * _mxarray25_;
static mxArray * _mxarray27_;
static mxArray * _mxarray28_;
static mxArray * _mxarray29_;
static mxArray * _mxarray30_;
static mxArray * _mxarray31_;
static mxArray * _mxarray32_;
static mxArray * _mxarray33_;
static mxArray * _mxarray34_;
static mxArray * _mxarray35_;

void InitializeModule_signal_private_gencoswin(void) {
    _mxarray0_ = mclInitializeDouble(1.0);
    _mxarray1_ = mclInitializeDouble(2.0);
    _mxarray2_ = mclInitializeCharVector(0, 0, (mxChar *)NULL);
    _mxarray3_ = mclInitializeString(9, _array4_);
    _mxarray5_ = mclInitializeDouble(3.0);
    _array7_[0] = _mxarray3_;
    _mxarray8_ = mclInitializeString(8, _array9_);
    _array7_[1] = _mxarray8_;
    _mxarray6_ = mclInitializeCellVector(1, 2, _array7_);
    _mxarray10_ = mclInitializeString(55, _array11_);
    _mxarray12_ = mclInitializeDouble(-1.0);
    _mxarray13_ = mclInitializeString(4, _array14_);
    _mxarray15_ = mclInitializeDouble(.5);
    _mxarray16_ = mclInitializeDouble(0.0);
    _mxarray17_ = mclInitializeString(7, _array18_);
    _mxarray19_ = mclInitializeDouble(.54);
    _mxarray20_ = mclInitializeDouble(.46);
    _mxarray21_ = mclInitializeString(8, _array22_);
    _mxarray23_ = mclInitializeDouble(.42);
    _mxarray24_ = mclInitializeDouble(.08);
    _mxarray25_ = mclInitializeString(10, _array26_);
    _mxarray27_ = mclInitializeDouble(.2156);
    _mxarray28_ = mclInitializeDouble(.416);
    _mxarray29_ = mclInitializeDouble(.2781);
    _mxarray30_ = mclInitializeDouble(.0836);
    _mxarray31_ = mclInitializeDouble(.0069);
    _mxarray32_ = mclInitializeDouble(6.283185307179586);
    _mxarray33_ = mclInitializeDouble(12.566370614359172);
    _mxarray34_ = mclInitializeDouble(18.84955592153876);
    _mxarray35_ = mclInitializeDouble(25.132741228718345);
}

void TerminateModule_signal_private_gencoswin(void) {
    mxDestroyArray(_mxarray35_);
    mxDestroyArray(_mxarray34_);
    mxDestroyArray(_mxarray33_);
    mxDestroyArray(_mxarray32_);
    mxDestroyArray(_mxarray31_);
    mxDestroyArray(_mxarray30_);
    mxDestroyArray(_mxarray29_);
    mxDestroyArray(_mxarray28_);
    mxDestroyArray(_mxarray27_);
    mxDestroyArray(_mxarray25_);
    mxDestroyArray(_mxarray24_);
    mxDestroyArray(_mxarray23_);
    mxDestroyArray(_mxarray21_);
    mxDestroyArray(_mxarray20_);
    mxDestroyArray(_mxarray19_);
    mxDestroyArray(_mxarray17_);
    mxDestroyArray(_mxarray16_);
    mxDestroyArray(_mxarray15_);
    mxDestroyArray(_mxarray13_);
    mxDestroyArray(_mxarray12_);
    mxDestroyArray(_mxarray10_);
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray8_);
    mxDestroyArray(_mxarray5_);
    mxDestroyArray(_mxarray3_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * mlfGencoswin_sym_window(mxArray * n, mxArray * window);
static void mlxGencoswin_sym_window(int nlhs,
                                    mxArray * plhs[],
                                    int nrhs,
                                    mxArray * prhs[]);
static mxArray * mlfGencoswin_calc_window(mxArray * m,
                                          mxArray * n,
                                          mxArray * window);
static void mlxGencoswin_calc_window(int nlhs,
                                     mxArray * plhs[],
                                     int nrhs,
                                     mxArray * prhs[]);
static mxArray * Msignal_private_gencoswin(mxArray * * msg,
                                           int nargout_,
                                           mxArray * varargin);
static mxArray * Mgencoswin_sym_window(int nargout_,
                                       mxArray * n,
                                       mxArray * window);
static mxArray * Mgencoswin_calc_window(int nargout_,
                                        mxArray * m,
                                        mxArray * n,
                                        mxArray * window);

static mexFunctionTableEntry local_function_table_[2]
  = { { "sym_window", mlxGencoswin_sym_window, 2, 1, NULL },
      { "calc_window", mlxGencoswin_calc_window, 3, 1, NULL } };

_mexLocalFunctionTable _local_function_table_signal_private_gencoswin
  = { 2, local_function_table_ };

/*
 * The function "mlfSignal_private_gencoswin" contains the normal interface for
 * the "signal/private/gencoswin" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 1-48). This
 * function processes any input arguments and passes them to the implementation
 * version of the function, appearing above.
 */
mxArray * mlfSignal_private_gencoswin(mxArray * * msg, ...) {
    mxArray * varargin = NULL;
    int nargout = 1;
    mxArray * w = NULL;
    mxArray * msg__ = NULL;
    mlfVarargin(&varargin, msg, 0);
    mlfEnterNewContext(1, -1, msg, varargin);
    if (msg != NULL) {
        ++nargout;
    }
    w = Msignal_private_gencoswin(&msg__, nargout, varargin);
    mlfRestorePreviousContext(1, 0, msg);
    mxDestroyArray(varargin);
    if (msg != NULL) {
        mclCopyOutputArg(msg, msg__);
    } else {
        mxDestroyArray(msg__);
    }
    return mlfReturnValue(w);
}

/*
 * The function "mlxSignal_private_gencoswin" contains the feval interface for
 * the "signal/private/gencoswin" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 1-48). The
 * feval function calls the implementation version of signal/private/gencoswin
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
void mlxSignal_private_gencoswin(int nlhs,
                                 mxArray * plhs[],
                                 int nrhs,
                                 mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[2];
    int i;
    if (nlhs > 2) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: signal/private/gencoswin Line: 1 Co"
            "lumn: 1 The function \"signal/private/gencoswin\" was cal"
            "led with more than the declared number of outputs (2)."),
          NULL);
    }
    for (i = 0; i < 2; ++i) {
        mplhs[i] = NULL;
    }
    mlfEnterNewContext(0, 0);
    mprhs[0] = NULL;
    mlfAssign(&mprhs[0], mclCreateVararginCell(nrhs, prhs));
    mplhs[0] = Msignal_private_gencoswin(&mplhs[1], nlhs, mprhs[0]);
    mlfRestorePreviousContext(0, 0);
    plhs[0] = mplhs[0];
    for (i = 1; i < 2 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 2; ++i) {
        mxDestroyArray(mplhs[i]);
    }
    mxDestroyArray(mprhs[0]);
}

/*
 * The function "mlfGencoswin_sym_window" contains the normal interface for the
 * "gencoswin/sym_window" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 48-67). This
 * function processes any input arguments and passes them to the implementation
 * version of the function, appearing above.
 */
static mxArray * mlfGencoswin_sym_window(mxArray * n, mxArray * window) {
    int nargout = 1;
    mxArray * w = NULL;
    mlfEnterNewContext(0, 2, n, window);
    w = Mgencoswin_sym_window(nargout, n, window);
    mlfRestorePreviousContext(0, 2, n, window);
    return mlfReturnValue(w);
}

/*
 * The function "mlxGencoswin_sym_window" contains the feval interface for the
 * "gencoswin/sym_window" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 48-67). The
 * feval function calls the implementation version of gencoswin/sym_window
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
static void mlxGencoswin_sym_window(int nlhs,
                                    mxArray * plhs[],
                                    int nrhs,
                                    mxArray * prhs[]) {
    mxArray * mprhs[2];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: gencoswin/sym_window Line: 48 Col"
            "umn: 1 The function \"gencoswin/sym_window\" was called"
            " with more than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 2) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: gencoswin/sym_window Line: 48 Co"
            "lumn: 1 The function \"gencoswin/sym_window\" was call"
            "ed with more than the declared number of inputs (2)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 2 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 2; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 2, mprhs[0], mprhs[1]);
    mplhs[0] = Mgencoswin_sym_window(nlhs, mprhs[0], mprhs[1]);
    mlfRestorePreviousContext(0, 2, mprhs[0], mprhs[1]);
    plhs[0] = mplhs[0];
}

/*
 * The function "mlfGencoswin_calc_window" contains the normal interface for
 * the "gencoswin/calc_window" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 67-122). This
 * function processes any input arguments and passes them to the implementation
 * version of the function, appearing above.
 */
static mxArray * mlfGencoswin_calc_window(mxArray * m,
                                          mxArray * n,
                                          mxArray * window) {
    int nargout = 1;
    mxArray * w = NULL;
    mlfEnterNewContext(0, 3, m, n, window);
    w = Mgencoswin_calc_window(nargout, m, n, window);
    mlfRestorePreviousContext(0, 3, m, n, window);
    return mlfReturnValue(w);
}

/*
 * The function "mlxGencoswin_calc_window" contains the feval interface for the
 * "gencoswin/calc_window" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 67-122). The
 * feval function calls the implementation version of gencoswin/calc_window
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
static void mlxGencoswin_calc_window(int nlhs,
                                     mxArray * plhs[],
                                     int nrhs,
                                     mxArray * prhs[]) {
    mxArray * mprhs[3];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: gencoswin/calc_window Line: 67 Co"
            "lumn: 1 The function \"gencoswin/calc_window\" was call"
            "ed with more than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 3) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: gencoswin/calc_window Line: 67 Co"
            "lumn: 1 The function \"gencoswin/calc_window\" was call"
            "ed with more than the declared number of inputs (3)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 3 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 3; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 3, mprhs[0], mprhs[1], mprhs[2]);
    mplhs[0] = Mgencoswin_calc_window(nlhs, mprhs[0], mprhs[1], mprhs[2]);
    mlfRestorePreviousContext(0, 3, mprhs[0], mprhs[1], mprhs[2]);
    plhs[0] = mplhs[0];
}

/*
 * The function "Msignal_private_gencoswin" is the implementation version of
 * the "signal/private/gencoswin" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 1-48). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function [w,msg] = gencoswin(varargin)
 */
static mxArray * Msignal_private_gencoswin(mxArray * * msg,
                                           int nargout_,
                                           mxArray * varargin) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(
          &_local_function_table_signal_private_gencoswin);
    int nargin_ = mclNargin(-1, varargin, NULL);
    mxArray * w = NULL;
    mxArray * sflagindex = NULL;
    mxArray * allsflags = NULL;
    mxArray * sflag = NULL;
    mxArray * trivialwin = NULL;
    mxArray * n = NULL;
    mxArray * window = NULL;
    mclCopyArray(&varargin);
    /*
     * %GENCOSWIN   Returns one of the generalized cosine windows.
     * %   GENCOSWIN returns the generalized cosine window specified by the 
     * %   first string argument. Its inputs can be
     * %     Window name    - a string, any of 'hamming', 'hann', 'blackman'.
     * %     N              - length of the window desired.
     * %     Sampling flag  - optional string, one of 'symmetric', 'periodic'. 
     * 
     * %   Copyright 1988-2002 The MathWorks, Inc.
     * %   $Revision: 1.7 $  $Date: 2002/03/28 17:29:46 $ 
     * 
     * % Parse the inputs
     * window = varargin{1};
     */
    mlfAssign(
      &window, mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray0_));
    /*
     * n = varargin{2};
     */
    mlfAssign(&n, mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray1_));
    /*
     * msg = '';
     */
    mlfAssign(msg, _mxarray2_);
    /*
     * 
     * % Check for trivial orders
     * [n,w,trivialwin] = check_order(n);
     */
    mlfAssign(
      &n, mlfSignal_private_check_order(&w, &trivialwin, mclVv(n, "n")));
    /*
     * if trivialwin, return, end;
     */
    if (mlfTobool(mclVv(trivialwin, "trivialwin"))) {
        goto return_;
    }
    /*
     * 
     * % Select the sampling option
     * if nargin == 2, % no sampling flag specified, use default. 
     */
    if (nargin_ == 2) {
        /*
         * sflag = 'symmetric';
         */
        mlfAssign(&sflag, _mxarray3_);
    /*
     * else
     */
    } else {
        /*
         * sflag = lower(varargin{3});
         */
        mlfAssign(
          &sflag,
          mclFeval(
            mclValueVarargout(),
            mlxLower,
            mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray5_),
            NULL));
    /*
     * end
     */
    }
    /*
     * 
     * % Allow partial strings for sampling options
     * allsflags = {'symmetric','periodic'};
     */
    mlfAssign(&allsflags, _mxarray6_);
    /*
     * sflagindex = strmatch(sflag, allsflags);
     */
    mlfAssign(
      &sflagindex,
      mlfStrmatch(mclVv(sflag, "sflag"), mclVv(allsflags, "allsflags"), NULL));
    /*
     * if length(sflagindex)~=1         % catch 0 or 2 matches
     */
    if (mclLengthInt(mclVv(sflagindex, "sflagindex")) != 1) {
        /*
         * msg = 'Sampling flag must be either ''symmetric'' or ''periodic''.';
         */
        mlfAssign(msg, _mxarray10_);
        /*
         * return;
         */
        goto return_;
    /*
     * else	
     */
    } else {
        /*
         * sflag = allsflags{sflagindex};
         */
        mlfAssign(
          &sflag,
          mlfIndexRef(
            mclVv(allsflags, "allsflags"),
            "{?}",
            mclVv(sflagindex, "sflagindex")));
    /*
     * end
     */
    }
    /*
     * 
     * % Evaluate the window
     * switch sflag
     */
    {
        mxArray * v_ = mclInitialize(mclVv(sflag, "sflag"));
        if (mclSwitchCompare(v_, _mxarray8_)) {
            /*
             * case 'periodic'
             * w = sym_window(n+1,window);
             */
            mlfAssign(
              &w,
              mlfGencoswin_sym_window(
                mclPlus(mclVv(n, "n"), _mxarray0_), mclVv(window, "window")));
            /*
             * w(end) = [];
             */
            mlfIndexDelete(
              &w, "(?)", mlfEnd(mclVv(w, "w"), _mxarray0_, _mxarray0_));
        /*
         * case 'symmetric'
         */
        } else if (mclSwitchCompare(v_, _mxarray3_)) {
            /*
             * w = sym_window(n,window);
             */
            mlfAssign(
              &w,
              mlfGencoswin_sym_window(mclVv(n, "n"), mclVv(window, "window")));
        /*
         * end
         */
        }
        mxDestroyArray(v_);
    }
    /*
     * 
     * %---------------------------------------------------------------------
     */
    return_:
    mclValidateOutput(w, 1, nargout_, "w", "signal/private/gencoswin");
    mclValidateOutput(*msg, 2, nargout_, "msg", "signal/private/gencoswin");
    mxDestroyArray(window);
    mxDestroyArray(n);
    mxDestroyArray(trivialwin);
    mxDestroyArray(sflag);
    mxDestroyArray(allsflags);
    mxDestroyArray(sflagindex);
    mxDestroyArray(varargin);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return w;
}

/*
 * The function "Mgencoswin_sym_window" is the implementation version of the
 * "gencoswin/sym_window" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 48-67). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function w = sym_window(n,window)
 */
static mxArray * Mgencoswin_sym_window(int nargout_,
                                       mxArray * n,
                                       mxArray * window) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(
          &_local_function_table_signal_private_gencoswin);
    mxArray * w = NULL;
    mxArray * half = NULL;
    mclCopyArray(&n);
    mclCopyArray(&window);
    /*
     * %SYM_WINDOW   Symmetric generalized cosine window.
     * %   SYM_WINDOW Returns an exactly symmetric N point generalized cosine 
     * %   window by evaluating the first half and then flipping the same samples
     * %   over the other half.
     * 
     * if ~rem(n,2)
     */
    if (mclNotBool(mlfRem(mclVa(n, "n"), _mxarray1_))) {
        /*
         * % Even length window
         * half = n/2;
         */
        mlfAssign(&half, mclMrdivide(mclVa(n, "n"), _mxarray1_));
        /*
         * w = calc_window(half,n,window);
         */
        mlfAssign(
          &w,
          mlfGencoswin_calc_window(
            mclVv(half, "half"), mclVa(n, "n"), mclVa(window, "window")));
        /*
         * w = [w; w(end:-1:1)];
         */
        mlfAssign(
          &w,
          mlfVertcat(
            mclVv(w, "w"),
            mclArrayRef1(
              mclVv(w, "w"),
              mlfColon(
                mlfEnd(mclVv(w, "w"), _mxarray0_, _mxarray0_),
                _mxarray12_,
                _mxarray0_)),
            NULL));
    /*
     * else
     */
    } else {
        /*
         * % Odd length window
         * half = (n+1)/2;
         */
        mlfAssign(
          &half, mclMrdivide(mclPlus(mclVa(n, "n"), _mxarray0_), _mxarray1_));
        /*
         * w = calc_window(half,n,window);
         */
        mlfAssign(
          &w,
          mlfGencoswin_calc_window(
            mclVv(half, "half"), mclVa(n, "n"), mclVa(window, "window")));
        /*
         * w = [w; w(end-1:-1:1)];
         */
        mlfAssign(
          &w,
          mlfVertcat(
            mclVv(w, "w"),
            mclArrayRef1(
              mclVv(w, "w"),
              mlfColon(
                mclMinus(
                  mlfEnd(mclVv(w, "w"), _mxarray0_, _mxarray0_), _mxarray0_),
                _mxarray12_,
                _mxarray0_)),
            NULL));
    /*
     * end
     */
    }
    mclValidateOutput(w, 1, nargout_, "w", "gencoswin/sym_window");
    mxDestroyArray(half);
    mxDestroyArray(window);
    mxDestroyArray(n);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return w;
    /*
     * 
     * %---------------------------------------------------------------------
     */
}

/*
 * The function "Mgencoswin_calc_window" is the implementation version of the
 * "gencoswin/calc_window" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\gencoswin.m" (lines 67-122). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function w = calc_window(m,n,window)
 */
static mxArray * Mgencoswin_calc_window(int nargout_,
                                        mxArray * m,
                                        mxArray * n,
                                        mxArray * window) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(
          &_local_function_table_signal_private_gencoswin);
    mxArray * w = NULL;
    mxArray * x = NULL;
    mxArray * a4 = NULL;
    mxArray * a3 = NULL;
    mxArray * a2 = NULL;
    mxArray * a1 = NULL;
    mxArray * a0 = NULL;
    mclCopyArray(&m);
    mclCopyArray(&n);
    mclCopyArray(&window);
    /*
     * %CALC_WINDOW   Calculate the generalized cosine window samples.
     * %   CALC_WINDOW Calculates and returns the first M points of an N point
     * %   generalized cosine window determined by the 'window' string.
     * 
     * % For the hamming and blackman windows we force rounding in order to achieve
     * % better numerical properties.  For example, the end points of the hamming 
     * % window should be exactly 0.08.
     * 
     * switch window
     */
    {
        mxArray * v_ = mclInitialize(mclVa(window, "window"));
        if (mclSwitchCompare(v_, _mxarray13_)) {
            /*
             * case 'hann'
             * % Hann window
             * %    w = 0.5 * (1 - cos(2*pi*(0:m-1)'/(n-1))); 
             * a0 = 0.5;
             */
            mlfAssign(&a0, _mxarray15_);
            /*
             * a1 = 0.5;
             */
            mlfAssign(&a1, _mxarray15_);
            /*
             * a2 = 0;
             */
            mlfAssign(&a2, _mxarray16_);
            /*
             * a3 = 0;
             */
            mlfAssign(&a3, _mxarray16_);
            /*
             * a4 = 0;
             */
            mlfAssign(&a4, _mxarray16_);
        /*
         * case 'hamming'
         */
        } else if (mclSwitchCompare(v_, _mxarray17_)) {
            /*
             * % Hamming window
             * %    w = (54 - 46*cos(2*pi*(0:m-1)'/(n-1)))/100;
             * a0 = 0.54;
             */
            mlfAssign(&a0, _mxarray19_);
            /*
             * a1 = 0.46;
             */
            mlfAssign(&a1, _mxarray20_);
            /*
             * a2 = 0;
             */
            mlfAssign(&a2, _mxarray16_);
            /*
             * a3 = 0;
             */
            mlfAssign(&a3, _mxarray16_);
            /*
             * a4 = 0;
             */
            mlfAssign(&a4, _mxarray16_);
        /*
         * case 'blackman'
         */
        } else if (mclSwitchCompare(v_, _mxarray21_)) {
            /*
             * % Blackman window
             * %    w = (42 - 50*cos(2*pi*(0:m-1)/(n-1)) + 8*cos(4*pi*(0:m-1)/(n-1)))'/100;
             * a0 = 0.42;
             */
            mlfAssign(&a0, _mxarray23_);
            /*
             * a1 = 0.5;
             */
            mlfAssign(&a1, _mxarray15_);
            /*
             * a2 = 0.08;
             */
            mlfAssign(&a2, _mxarray24_);
            /*
             * a3 = 0;
             */
            mlfAssign(&a3, _mxarray16_);
            /*
             * a4 = 0;
             */
            mlfAssign(&a4, _mxarray16_);
        /*
         * case 'flattopwin'
         */
        } else if (mclSwitchCompare(v_, _mxarray25_)) {
            /*
             * % Flattop window
             * % Original coefficients as defined in the reference (see flattopwin.m);
             * % a0 = 1;
             * % a1 = 1.93;
             * % a2 = 1.29;
             * % a3 = 0.388;
             * % a4 = 0.032;
             * %
             * % Scaled by (a0+a1+a2+a3+a4)
             * a0 = 0.2156;
             */
            mlfAssign(&a0, _mxarray27_);
            /*
             * a1 = 0.4160;
             */
            mlfAssign(&a1, _mxarray28_);
            /*
             * a2 = 0.2781;
             */
            mlfAssign(&a2, _mxarray29_);
            /*
             * a3 = 0.0836;
             */
            mlfAssign(&a3, _mxarray30_);
            /*
             * a4 = 0.0069;
             */
            mlfAssign(&a4, _mxarray31_);
        /*
         * end
         */
        }
        mxDestroyArray(v_);
    }
    /*
     * 
     * x = (0:m-1)'/(n-1);
     */
    mlfAssign(
      &x,
      mclMrdivide(
        mlfCtranspose(
          mlfColon(_mxarray16_, mclMinus(mclVa(m, "m"), _mxarray0_), NULL)),
        mclMinus(mclVa(n, "n"), _mxarray0_)));
    /*
     * w = a0 - a1*cos(2*pi*x) + a2*cos(4*pi*x) - a3*cos(6*pi*x) + a4*cos(8*pi*x);
     */
    mlfAssign(
      &w,
      mclPlus(
        mclMinus(
          mclPlus(
            mclMinus(
              mclVv(a0, "a0"),
              mclMtimes(
                mclVv(a1, "a1"),
                mlfCos(mclMtimes(_mxarray32_, mclVv(x, "x"))))),
            mclMtimes(
              mclVv(a2, "a2"), mlfCos(mclMtimes(_mxarray33_, mclVv(x, "x"))))),
          mclMtimes(
            mclVv(a3, "a3"), mlfCos(mclMtimes(_mxarray34_, mclVv(x, "x"))))),
        mclMtimes(
          mclVv(a4, "a4"), mlfCos(mclMtimes(_mxarray35_, mclVv(x, "x"))))));
    mclValidateOutput(w, 1, nargout_, "w", "gencoswin/calc_window");
    mxDestroyArray(a0);
    mxDestroyArray(a1);
    mxDestroyArray(a2);
    mxDestroyArray(a3);
    mxDestroyArray(a4);
    mxDestroyArray(x);
    mxDestroyArray(window);
    mxDestroyArray(n);
    mxDestroyArray(m);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return w;
    /*
     * 
     * % [EOF] gencoswin.m
     */
}
